-- Migration to add validation_data column to certificate_templates table
-- This column will store JSON data about template validation results

USE `certifyed`;

-- Add validation_data column to certificate_templates table
ALTER TABLE `certificate_templates` 
ADD COLUMN `validation_data` JSON DEFAULT NULL COMMENT 'Stores template validation results including FPDI compatibility';

-- Add index for better performance when querying validation data
ALTER TABLE `certificate_templates` 
ADD INDEX `idx_validation_fpdi_compatible` ((JSON_EXTRACT(`validation_data`, '$.fpdi_compatible')));

-- Update existing templates with default validation data (mark as unknown)
UPDATE `certificate_templates` 
SET `validation_data` = JSON_OBJECT(
    'is_valid', true,
    'fpdi_compatible', null,
    'issues', JSON_ARRAY(),
    'recommendations', JSON_ARRAY(),
    'validated_at', null,
    'validation_status', 'unknown'
) 
WHERE `validation_data` IS NULL;