<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
if (empty($_SESSION['admin_logged_in'])) {
    echo "<script>window.top.location.href = 'login.php';</script>";
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin Dashboard - CertifyEd</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <div style="text-align:center;margin-bottom:18px;">
            <img src="../img/logo.png" alt="Logo" style="max-width:120px;width:60%;height:auto;display:inline-block;">
            <h1 style="font-size:1.6rem;font-weight:600;margin:12px 0 0 0;letter-spacing:1px;">Certificate Generation System</h1>
        </div>
        <div style="text-align:right; margin-bottom:10px; font-size:1rem; color:#333;">
    <h3><strong><?= htmlspecialchars($_SESSION['admin_name']) ?></strong></h3>
</div>
        <div class="dashboard-wrapper">
            <nav class="dashboard-nav">
            <a href="#" onclick="loadPage('search_certificates.php'); return false;">Search Certificates</a>
                <a href="#" onclick="loadPage('users.php'); return false;">Manage Users</a>
                <a href="#" onclick="loadPage('templates.php'); return false;">Manage Certificate Templates</a>
                <a href="#" onclick="loadPage('license_codes.php'); return false;">Manage License Codes</a>
                <a href="#" onclick="loadPage('generate_certificate.php'); return false;">Generate Certificate - Verified Teachers</a>
                <a href="#" onclick="loadPage('teacher_links.php'); return false;">Get Direct Teacher Certificate Links</a>
                <a href="#" onclick="loadPage('student_certificate.php'); return false;">Bulk Student Certificate Generator</a>
                <a href="#" onclick="loadPage('protected_bulk_selection.php'); return false;">Bulk Teacher Certificate Generator</a>
                <a href="#" onclick="loadPage('reset_password.php'); return false;">Reset Password</a>
                <a href="logout.php">Logout</a>
            </nav>
            <div class="dashboard-content">
                    <div id="dashboard-welcome" style="text-align:center; margin-top: 30px;">
                        <h2 style="margin-bottom: 8px;">Welcome, <?= htmlspecialchars($_SESSION['admin_name']) ?></h2>
                        <p style="font-size: 1.1rem; color: #444;">Select an option from the left to manage the system.</p>
                    </div>
                
                <iframe id="dashboard-iframe" src="" style="width:100%;height:70vh;border:none;border-radius:8px;background:#fff;display:none;"></iframe>
            </div>
        </div>
    </div>
    <script>
    function loadPage(page) {
        document.getElementById('dashboard-iframe').src = page;
        document.getElementById('dashboard-iframe').style.display = 'block';
        document.getElementById('dashboard-welcome').style.display = 'none';
        // Optionally, highlight the active link
        var links = document.querySelectorAll('.dashboard-nav a');
        links.forEach(l => l.classList.remove('active'));
        var found = Array.from(links).find(l => l.getAttribute('onclick') && l.getAttribute('onclick').includes(page));
        if (found) found.classList.add('active');
    }
    </script>
</body>
</html>