<?php
// Bulk certificate download handler
$file = $_GET['file'] ?? '';
$type = $_GET['type'] ?? '';

if (!$file || !$type) {
    http_response_code(404);
    die('Invalid download request');
}

// Handle new temp-based downloads
if ($type === 'zip' && preg_match('/^bulk_zip_[a-f0-9.]+$/', $file)) {
    // New temp-based download system
    $temp_file = __DIR__ . '/../storage/temp/' . $file . '.zip';
    
    if (!file_exists($temp_file)) {
        http_response_code(404);
        die('File not found or expired');
    }
    
    // Check file age - delete if older than 1 hour
    if (filemtime($temp_file) < time() - 3600) {
        unlink($temp_file);
        http_response_code(404);
        die('Download link expired');
    }
    
    // Output the ZIP file
    header('Content-Type: application/zip');
    header('Content-Disposition: attachment; filename="certificates.zip"');
    header('Content-Length: ' . filesize($temp_file));
    
    readfile($temp_file);
    
    // Clean up the temporary file after download
    unlink($temp_file);
    exit;
}

// Legacy bulk download system
// Validate file name and type
if (!preg_match('/^[a-zA-Z0-9._-]+\.zip$/', $file)) {
    http_response_code(404);
    die('Invalid file name');
}

if (!in_array($type, ['student', 'protected'])) {
    http_response_code(404);
    die('Invalid certificate type');
}

// Construct file path based on type
$base_dir = __DIR__ . '/../storage/certificates/bulk/';
$file_path = $base_dir . $type . '/' . date('Y/m/d') . '/' . $file;

if (!file_exists($file_path)) {
    http_response_code(404);
    die('File not found or expired');
}

// Check file age - delete if older than 1 hour
if (filemtime($file_path) < time() - 3600) {
    unlink($file_path);
    http_response_code(404);
    die('Download link expired');
}

// Output the ZIP file
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="certificates.zip"');
header('Content-Length: ' . filesize($file_path));

readfile($file_path);

// Clean up the file after download
unlink($file_path);

// Try to clean up empty directories
$dir = dirname($file_path);
if (is_dir($dir) && count(scandir($dir)) == 2) { // Only . and ..
    rmdir($dir);
}

exit;
?>