<?php
require_once __DIR__ . '/../config/config.php';
session_start();

$license_code = $_GET['license_code'] ?? '';
if (!$license_code) die("Invalid download link.");

$pdo = getDbConnection();
$stmt = $pdo->prepare("SELECT * FROM certificates WHERE license_code = ?");
$stmt->execute([$license_code]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$row) die("Invalid or expired download link.");

// If not logged in as admin/user, enforce single-use and expiry
if (empty($_SESSION['admin_logged_in']) && empty($_SESSION['user_logged_in'])) {
    // Check if already downloaded
    if ($row['download_used']) {
        echo '<!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Link Used</title>
            <style>
                body { background: #f7f7f7; margin: 0; font-family: Arial, sans-serif; }
                .center-message { display: flex; flex-direction: column; align-items: center; justify-content: center; min-height: 80vh; }
                .message-box { background: #fff; border-radius: 12px; box-shadow: 0 2px 12px rgba(0,0,0,0.08); padding: 36px 52px; text-align: center; }
                .obs-logo { width: 120px; margin-bottom: 28px; }
                .msg-text { font-size: 1.4rem; color: #222; }
            </style>
        </head>
        <body>
            <div class="center-message">
                <div class="message-box">
                    <img src="../img/logo.png" alt="OBS Logo" class="obs-logo">
                    <div class="msg-text">This link has already been used.</div>
                </div>
            </div>
        </body>
        </html>';
        exit;
    }

    // Check if expired (24 hours since download_created_at)
    if (strtotime($row['download_created_at']) < time() - 86400) die("This link has expired.");

    // Mark as used BEFORE sending file
    $stmt = $pdo->prepare("UPDATE certificates SET download_used = 1 WHERE id = ?");
    $stmt->execute([$row['id']]);
}

// Output PDF
$file = __DIR__ . '/../storage/certificates/' . $row['file_path'];
if (!file_exists($file)) die("Certificate file not found.");

header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="certificate.pdf"');
readfile($file);
exit;
?>