<?php
// download_student_zip.php - Handles secure download of student certificate ZIPs
$token = $_GET['token'] ?? '';
if (!$token) die('Invalid download link.');

$storage_dir = __DIR__ . '/../storage/';
$found = false;
$zip_path = '';

foreach (glob($storage_dir . 'tmp_certs_*/.meta') as $meta_file) {
    $meta = json_decode(file_get_contents($meta_file), true);
    if ($meta && ($meta['token'] ?? '') === $token) {
        // Check expiry (1 day)
        if (time() - ($meta['created_at'] ?? 0) > 86400) {
            die('Download link expired.');
        }
        $dir = dirname($meta_file);
        $zip_path = $dir . '/certificates.zip';
        if (!file_exists($zip_path)) die('ZIP file not found.');
        $found = true;
        break;
    }
}

if (!$found) die('Invalid or expired download link.');

header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="student_certificates.zip"');
header('Content-Length: ' . filesize($zip_path));
readfile($zip_path);
exit;
