<?php
session_start();
require_once __DIR__ . '/../config/config.php';

$error = '';
$success = '';
$template = null;

// Step 1: Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $license_code = trim($_POST['license_code']);

    // Validate license code
    $pdo = getDbConnection();
    $stmt = $pdo->prepare("SELECT lc.*, ct.file_path, ct.field_definitions, ct.field_coordinates, ct.id as template_id FROM license_codes lc
        JOIN certificate_templates ct ON lc.template_id = ct.id
        WHERE lc.code = ? AND lc.status = 'unused' LIMIT 1");
    $stmt->execute([$license_code]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row) {
        $error = "Invalid or already used license code.";
    } else {
        // Ensure download_created_at is set for expiry logic
        if (empty($row['download_created_at'])) {
            $stmt = $pdo->prepare("UPDATE license_codes SET download_created_at = NOW() WHERE id = ?");
            $stmt->execute([$row['id']]);
            $row['download_created_at'] = date('Y-m-d H:i:s');
        }
        // Generate a secure random token
        $token = bin2hex(random_bytes(16)); // 32-char hex string
        // Store the token in the license_codes table
        $stmt = $pdo->prepare("UPDATE license_codes SET token = ? WHERE code = ?");
        $stmt->execute([$token, $license_code]);
        // Generate the public link
        $public_link = "certificate_form.php?token=" . urlencode($token);
        $full_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") .
            "://{$_SERVER['HTTP_HOST']}" .
            dirname($_SERVER['REQUEST_URI']) . "/$public_link";
        $success = <<<HTML
<div class="copy-link-row" style="display:flex;flex-direction:column;align-items:center;justify-content:center;margin-top:10px;">
    <input type='text' id='formUrl' value='$full_url' readonly style='width:70%;max-width:440px;padding:8px;font-size:1rem;margin-bottom:12px;text-align:center;'>
    <button id="copyBtn" class="btn" style="padding:8px 18px;font-size:1rem;cursor:pointer;margin-bottom:8px;">Copy Link</button>
    <span id="copyMsg" style="color:green;font-weight:500;margin-top:2px;display:none;">Link copied</span>
</div>
<script>
document.getElementById('copyBtn').onclick = function() {
    var input = document.getElementById('formUrl');
    input.select();
    input.setSelectionRange(0, 99999);
    document.execCommand('copy');
    document.getElementById('copyMsg').style.display = 'inline';
    setTimeout(function() {
        document.getElementById('copyMsg').style.display = 'none';
    }, 2000);
    return false;
};
</script>
HTML;
    }
}
?>
<html>
<head>
    <title>Generate Certificate - CertifyEd</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .result-section { margin-top: 28px; text-align: center; }
        .result-section input[type=text] { width: 80%; max-width: 480px; padding: 8px; font-size: 1rem; }
        .form-section { max-width: 500px; margin: 0 auto; background: #fff; border-radius: 8px; box-shadow: 0 2px 12px #0001; padding: 32px 28px 24px 28px; }
        .btn {
            background: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            padding: 8px 18px;
            font-size: 1rem;
            cursor: pointer;
            transition: background 0.2s;
        }
        .btn:hover {
            background: #0056b3;
        }
    </style>
</head>
<body>
    <h2 style="text-align:center;margin-bottom:20px;">Generate Certificate</h2>
    <div class="form-section">
        <?php if ($error): ?><p style="color:red; text-align:center;"><?= htmlspecialchars($error) ?></p><?php endif; ?>
        <form method="post">
            <label>License Code: <input type="text" name="license_code" value="<?= htmlspecialchars($_POST['license_code'] ?? '') ?>" required></label><br>
            <button type="submit" class="btn">Validate License Code</button>
        </form>
    </div>
    <?php if ($success): ?>
    <div class="result-section">
        <?= $success ?>
    </div>
    <?php endif; ?>
</body>
</html>