<?php
session_start();
require_once __DIR__ . '/../config/config.php';

if (empty($_SESSION['user_logged_in']) && empty($_SESSION['admin_logged_in'])) {
    echo "<script>window.top.location.href = 'login.php';</script>";
    exit;
}

$pdo = getDbConnection();
$error = '';
$success = '';

// Handle code deletion (only unused codes)
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $pdo->prepare("DELETE FROM license_codes WHERE id = ? AND status = 'unused'");
    $stmt->execute([$id]);
    $success = "License code deleted.";
}

// Handle code generation
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['generate_codes'])) {
    $count = max(1, intval($_POST['count']));
    $template_id = intval($_POST['template_id']);
    for ($i = 0; $i < $count; $i++) {
        $code = strtoupper(bin2hex(random_bytes(4))); // 8-char code
        $stmt = $pdo->prepare("INSERT INTO license_codes (code, email, template_id, status) VALUES (?, ?, ?, 'unused')");
        $stmt->execute([$code, '', $template_id]);
    }
    $success = "$count license code(s) generated.";
}

// Fetch only active protected templates for mapping
$templates = $pdo->query("SELECT id, name FROM certificate_templates WHERE use_case_type = 'protected' AND status = 'active' ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

// Fetch all codes
$stmt = $pdo->query("SELECT lc.*, ct.name as template_name FROM license_codes lc LEFT JOIN certificate_templates ct ON lc.template_id = ct.id ORDER BY lc.id DESC");
$codes = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>License Code Management - CertifyEd</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <h2 style="text-align:center;margin-bottom:20px;">License Code Management</h2>
   
    <?php if ($error): ?><p style="color:red; text-align:center;"><?= htmlspecialchars($error) ?></p><?php endif; ?>
    <?php if ($success): ?><p style="color:green; text-align:center;"><?= htmlspecialchars($success) ?></p><?php endif; ?>

    <div class="user-form-section">
        <h3>Generate License Codes</h3>
        <form method="post">
            <input type="hidden" name="generate_codes" value="1">
            <label>Number of codes: <input type="number" name="count" value="1" min="1" max="100" required></label><br>
            <label>For Template:
                <select name="template_id" required>
                    <?php foreach ($templates as $tpl): ?>
                        <option value="<?= $tpl['id'] ?>"><?= htmlspecialchars($tpl['name']) ?></option>
                    <?php endforeach; ?>
                </select>
            </label><br>
            <button type="submit" class="btn">Generate</button>
        </form>
    </div>

    <div class="user-table-section">
        <h3>All License Codes</h3>
        <table border="1" cellpadding="6">
            <tr>
                <th>ID</th>
                <th>Code</th>
                <th>Template</th>
                <th>Status</th>
                <th>Email</th>
                <th>Created</th>
                <th>Used At</th>
                <th>Actions</th>
            </tr>
            <?php foreach ($codes as $c): ?>
            <tr>
                <td><?= $c['id'] ?></td>
                <td><?= htmlspecialchars($c['code']) ?></td>
                <td><?= htmlspecialchars($c['template_name']) ?></td>
                <td><?= htmlspecialchars($c['status']) ?></td>
                <td><?= htmlspecialchars($c['email']) ?></td>
                <td><?= htmlspecialchars($c['created_at']) ?></td>
                <td><?= $c['used_at'] ? htmlspecialchars($c['used_at']) : '-' ?></td>
                <td style="text-align:center;">
                    <?php if ($c['status'] === 'unused'): ?>
                        <a href="license_codes.php?delete=<?= $c['id'] ?>" onclick="return confirm('Delete this code?')">
                            <img src="../img/delete.png" alt="Delete" title="Delete" style="width:18px;height:18px;vertical-align:middle;">
                        </a>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</div></body>
</html>