<?php
session_start();
require_once __DIR__ . '/../config/config.php';

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    $pdo = getDbConnection();
    // Try super_admin or admin login first
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? AND (role = 'admin' OR role = 'super_admin')");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password_hash'])) {
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_email'] = $user['email'];
        $_SESSION['admin_name'] = $user['name'];
        $_SESSION['admin_role'] = $user['role'];
        header('Location: admin_dashboard.php');
        exit;
    }

    // Try backend_user (regular user) login
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? AND role = 'backend_user'");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password_hash'])) {
        $_SESSION['user_logged_in'] = true;
        $_SESSION['user_email'] = $user['email'];
        $_SESSION['user_name'] = $user['name']; // PATCH: store user name for dashboard
        header('Location: user_dashboard.php');
        exit;
    }

    // If neither login worked, show error to user
    $error = 'Invalid login.';
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin Login - CertifyEd</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container" style="max-width: 400px;">
    <div style="text-align:center;margin-bottom:18px;">
        <img src="../img/logo.png" alt="Logo" style="max-width:120px;width:60%;height:auto;display:inline-block;">
        <div style="margin-top:10px;font-size:25px;font-weight:bold;color:#333;">Certificate Generation System</div>
    </div>
    <?php if ($error): ?>
        <p style="color:red;"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>
    <form method="post">
        <label for="email">Email:</label>
        <input type="email" id="email" name="email" required>
        <label for="password">Password:</label>
        <input type="password" id="password" name="password" required>
        <div style="text-align:center;">
            <button type="submit" class="btn">Login</button>
        </div>
    </form>
</div>
</body>
</html>