<?php
session_start();
require_once __DIR__ . '/../config/config.php';

// Teacher bulk certificate selection is accessible to all users (no admin restriction)

$pdo = getDbConnection();

// Fetch all active general teacher templates
$stmt = $pdo->prepare("SELECT * FROM certificate_templates WHERE use_case_type = 'general_teacher' AND status = 'active' ORDER BY name");
$stmt->execute();
$templates = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Bulk Teachers Certificate Generator</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .container {
            max-width: 600px;
            margin: 40px auto;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
            padding: 32px;
            text-align: center;
        }
        .protected-badge {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 0.9em;
            font-weight: bold;
            display: inline-block;
            margin-bottom: 15px;
            box-shadow: 0 2px 8px rgba(102, 126, 234, 0.3);
        }
        select {
            padding: 8px 12px;
            border-radius: 4px;
            border: 1px solid #ccc;
            font-size: 1em;
            margin-left: 8px;
            min-width: 220px;
            transition: border-color 0.2s, box-shadow 0.2s;
        }
        select:focus {
            border-color: #667eea;
            box-shadow: 0 0 4px rgba(102, 126, 234, 0.3);
            outline: none;
        }
        #publicLink {
            padding: 8px 12px;
            border-radius: 4px;
            border: 1px solid #ccc;
            font-size: 1em;
            margin-top: 8px;
            margin-bottom: 8px;
            width: 60%;
            transition: border-color 0.2s, box-shadow 0.2s;
            box-sizing: border-box;
        }
        #publicLink:focus {
            border-color: #667eea;
            box-shadow: 0 0 4px rgba(102, 126, 234, 0.3);
            outline: none;
        }
        .btn {
            background: #667eea;
            color: #fff;
            border: none;
            padding: 8px 18px;
            border-radius: 4px;
            cursor: pointer;
            margin-left: 10px;
        }
        .btn:hover { background: #5a67d8; }
        .info-box {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 4px;
            padding: 15px;
            margin: 20px 0;
            border-left: 4px solid #ffc107;
            font-size: 0.9em;
        }
    </style>
</head>
<body>
<div style="display:flex;flex-direction:column;align-items:center;margin-top:36px;">
<img src="../img/logo.png" alt="Logo" style="width:120px;margin-bottom:18px;">
    <div class="protected-badge" style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%);">👨‍🏫 Teacher Certificates</div>
    <h2 style="text-align:center;">Bulk Teachers Certificate Generator</h2>
    
    <div class="info-box" style="background: #e8f5e9; border-left: 4px solid #28a745;">
        <strong>👨‍🏫 Teacher Certificates:</strong> Generate multiple teacher certificates at once using our bulk generation system. Perfect for training programs, workshops, and educational events.
    </div>
    
    <!-- Bulk Certificate Generation -->
        <h3 style="text-align: center; margin-bottom: 20px;">🔗 Bulk Teacher Certificate Generation</h3>
        <p style="text-align: center;">Generate multiple teacher certificates at once using Excel/CSV upload</p>
        
        <div style="text-align: center; margin-top: 20px;">
            <label for="bulk_template_id"><strong>Select Teacher Certificate Template:</strong></label>
            <select id="bulk_template_id">
                <option value="">-- Select Template --</option>
                <?php foreach ($templates as $tpl): ?>
                    <option value="<?= htmlspecialchars($tpl['id']) ?>"><?= htmlspecialchars($tpl['name']) ?></option>
                <?php endforeach; ?>
            </select>
           <br><br> <button type="button" id="createLinkBtn" class="btn">Create Bulk Generation Link</button>
        </div>
        
        <div id="publicLinkContainer" style="display:none; text-align:center; margin-top:20px;">
            <label><strong>Bulk Generation Link:</strong></label>
            <input type="text" id="publicLink" readonly style="width:70%;">
            <br><br><button type="button" id="copyLinkBtn" onclick="copyPublicLink()" class="btn">Copy Link</button>
            <span id="copyMsg" style="margin-left:12px;color:green;display:none;">Link copied!</span>
        </div>
        
       
    </div>
</div>
<script>
document.getElementById('createLinkBtn').onclick = function() {
    var templateId = document.getElementById('bulk_template_id').value;
    if (!templateId) {
        alert('Please select a template for bulk generation.');
        return;
    }
    var link = window.location.origin + '/CertifyEd/public/teacher_bulk_generate.php?template_id=' + templateId;
    document.getElementById('publicLink').value = link;
    document.getElementById('publicLinkContainer').style.display = 'block';
};

function copyPublicLink() {
    var input = document.getElementById('publicLink');
    input.select();
    input.setSelectionRange(0, 99999);
    document.execCommand('copy');

    var msg = document.getElementById('copyMsg');
    msg.style.display = 'inline';
    setTimeout(function() {
        msg.style.display = 'none';
    }, 1500);
}
</script>
</body>
</html>