<?php
session_start();
if (empty($_SESSION['user_logged_in']) && empty($_SESSION['admin_logged_in'])) {
    echo "<script>window.top.location.href = 'login.php';</script>";
    exit;
}
require_once __DIR__ . '/../config/config.php';

$error = '';
$success = '';

// Test message to see if styling works
if (isset($_GET['test'])) {
    $success = 'This is a test success message!';
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $new_password = $_POST['new_password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';
    
    if (empty($email) || empty($new_password) || empty($confirm_password)) {
        $error = 'All fields are required.';
    } elseif ($new_password !== $confirm_password) {
        $error = 'Passwords do not match.';
    } else {
        try {
            $pdo = getDbConnection();
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            
            // Allow users to change their own password or admins to change any password
            $stmt = null;
            if (!empty($_SESSION['admin_logged_in'])) {
                // Admin can change any user's password
                // First check if user exists
                $check_stmt = $pdo->prepare("SELECT id, email FROM users WHERE email = ?");
                $check_stmt->execute([$email]);
                $user_exists = $check_stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($user_exists) {
                    $stmt = $pdo->prepare("UPDATE users SET password_hash = ? WHERE email = ?");
                    $stmt->execute([$hashed_password, $email]);
                    
                    // Set success message immediately after successful update
                    if ($stmt->rowCount() > 0) {
                        $success = 'Password changed successfully!';
                    }
                } else {
                    $error = 'User not found in database.';
                }
            } else {
                // Regular users can only change their own password
                $logged_in_email = $_SESSION['user_email'] ?? '';
                if ($email !== $logged_in_email) {
                    $error = 'You can only change your own password.';
                } else {
                    // First check if user exists
                    $check_stmt = $pdo->prepare("SELECT id, email FROM users WHERE email = ?");
                    $check_stmt->execute([$email]);
                    $user_exists = $check_stmt->fetch(PDO::FETCH_ASSOC);
                    
                    if ($user_exists) {
                        $stmt = $pdo->prepare("UPDATE users SET password_hash = ? WHERE email = ?");
                        $stmt->execute([$hashed_password, $email]);

                        
                        // Set success message immediately after successful update
                        if ($stmt->rowCount() > 0) {
                            $success = 'Password changed successfully!';
                        }
                    } else {

                        $error = 'User not found in database.';
                    }
                }
            }
            

            

        } catch (PDOException $e) {
            $error = 'Error updating password: ' . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Reset Password - CertifyEd</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>

<?php if ($success): ?>
<script>
// Show success dialog and handle logout/redirect
if (confirm('<?= addslashes($success) ?>\n\nYou will now be logged out and redirected to the login page.')) {
    // User clicked OK - logout and redirect (break out of iframe)
    window.top.location.href = 'logout.php';
} else {
    // User clicked Cancel - still logout and redirect for security (break out of iframe)
    window.top.location.href = 'logout.php';
}
</script>
<?php endif; ?>

    <div style="text-align:center;margin-bottom:18px;">
       
        <h2>Change Password</h2>
    </div>
    

    <?php if ($error): ?>
        <div style="background-color:#f8d7da;color:#721c24;padding:12px;border:1px solid #f5c6cb;border-radius:4px;margin:20px auto;max-width:500px;text-align:center;"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    <?php if (!$success): ?>
        <form method="post">
            <label for="email">Email:</label>
            <?php 
            $current_email = '';
            if (!empty($_SESSION['admin_logged_in'])) {
                $current_email = $_SESSION['admin_email'] ?? '';
            } elseif (!empty($_SESSION['user_logged_in'])) {
                $current_email = $_SESSION['user_email'] ?? '';
            }
            ?>
            <input type="email" id="email" name="email" value="<?= htmlspecialchars($current_email) ?>" required readonly>
            <?php if (empty($_SESSION['admin_logged_in'])): ?>
                <small style="color:#666;font-size:0.9em;">You can only change your own password.</small>
            <?php endif; ?>
            
            <label for="new_password">New Password:</label>
            <input type="password" id="new_password" name="new_password" required>
            
            <label for="confirm_password">Confirm New Password:</label>
            <input type="password" id="confirm_password" name="confirm_password" required>
            
            <div style="text-align:center;margin-top:20px;">
                <button type="submit" class="btn">Change Password</button>
            </div>
        </form>
    <?php endif; ?>

</body>
</html>