<?php
session_start();
if (empty($_SESSION['user_logged_in']) && empty($_SESSION['admin_logged_in'])) {
    echo "<script>window.top.location.href = 'login.php';</script>";
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Search Certificates - CertifyEd</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .styled-table {
            border-collapse: collapse;
            margin: 0 auto 20px auto;
            font-size: 1rem;
            min-width: 700px;
            border: 1px solid #ccc;
            box-shadow: 0 2px 8px rgba(0,0,0,0.04);
            background: #fff;
        }
        .styled-table th, .styled-table td {
            border: 1px solid #ccc;
            padding: 10px 14px;
            text-align: left;
        }
        .styled-table th {
            background-color: #f4f4f4;
            font-weight: bold;
        }
        .styled-table tbody tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .styled-table tbody tr:hover {
            background-color: #e6f7ff;
        }
        .styled-table a {
            color: #007bff;
            text-decoration: none;
        }
        .styled-table a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
<div class="container" style="max-width:900px;margin:auto;">
    <h2 style="text-align:center;">Search Certificates</h2>
    <div style="text-align:center; margin-bottom: 20px;">
        <input type="text" id="searchInput" placeholder="Search by email, template name, or date..." style="width: 60%; padding: 8px; font-size: 1rem;">
    </div>
    <?php
    require_once __DIR__ . '/../config/config.php';
    $pdo = getDbConnection();
    $certificates = $pdo->query("SELECT c.id, c.email, c.created_at, c.license_code, c.file_path, t.name as template_name FROM certificates c LEFT JOIN certificate_templates t ON c.template_id = t.id WHERE t.use_case_type = 'protected' ORDER BY c.created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
    ?>
    <div style="overflow-x:auto;">
    <table id="certTable" class="styled-table" style="width:100%; border-collapse:collapse;">
        <thead>
            <tr>
                <th>Certificate ID</th>
                <th>Template Name</th>
                <th>Email</th>
                <th>Date</th>
                <th>Download</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($certificates as $cert): ?>
            <tr>
                <td><?= htmlspecialchars($cert['id']) ?></td>
                <td><?= htmlspecialchars($cert['template_name']) ?></td>
                <td><?= htmlspecialchars($cert['email']) ?></td>
                <td><?= htmlspecialchars($cert['created_at']) ?></td>
    <td>
        <?php if (!empty($cert['license_code'])): ?>
            <a href="download_certificate.php?license_code=<?= urlencode($cert['license_code']) ?>" target="_blank">Download</a>
        <?php else: ?>
            <a href="download_teacher_cert.php?file=<?= urlencode($cert['file_path']) ?>" target="_blank">Download</a>
        <?php endif; ?>
    </td>
</tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    </div>
    <script>
    document.getElementById('searchInput').addEventListener('keyup', function() {
        var filter = this.value.toLowerCase();
        var rows = document.querySelectorAll('#certTable tbody tr');
        rows.forEach(function(row) {
            var text = row.textContent.toLowerCase();
            row.style.display = text.includes(filter) ? '' : 'none';
        });
    });
    </script>

           
    </form>
    <?php
    $show_results = !empty($_GET['search_email']) || !empty($_GET['search_template']);
    if ($show_results) {
        $where = ["t.use_case_type = 'protected'"];
        $params = [];
        if (!empty($_GET['search_email'])) {
            $where[] = "c.email LIKE ?";
            $params[] = '%' . $_GET['search_email'] . '%';
        }
        if (!empty($_GET['search_template'])) {
            $where[] = "c.template_id = ?";
            $params[] = $_GET['search_template'];
        }
        $sql = "SELECT c.*, t.name AS template_name FROM certificates c JOIN certificate_templates t ON c.template_id = t.id";
        if ($where) $sql .= " WHERE " . implode(" AND ", $where);
        $sql .= " ORDER BY c.id DESC LIMIT 100";
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    ?>
    <div class="user-table-section" style="margin-top:24px;">
        <table border="1" cellpadding="6">
            <tr>
                <th>ID</th>
                <th>Template</th>
                <th>Recipient Email</th>
                <th>Date</th>
                <th>Download</th>
            </tr>
            <?php if ($results): foreach ($results as $row): ?>
            <tr>
                <td><?= htmlspecialchars($row['id']) ?></td>
                <td><?= htmlspecialchars($row['template_name']) ?></td>
                <td><?= htmlspecialchars($row['email']) ?></td>
                <td><?= htmlspecialchars($row['created_at'] ?? $row['download_created_at']) ?></td>
                <td>
                    <?php if (!empty($row['license_code'])): ?>
                        <a href="download_certificate.php?license_code=<?= urlencode($row['license_code']) ?>" target="_blank">Download</a>
                    <?php else: ?>
                        <a href="download_teacher_cert.php?file=<?= urlencode($row['file_path']) ?>" target="_blank">Download</a>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; else: ?>
            <tr><td colspan="5" style="text-align:center;">No results found.</td></tr>
            <?php endif; ?>
        </table>
    </div>
    <?php } ?>
</div>
</body>
</html>