<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../vendor/autoload.php';

use setasign\Fpdi\TcpdfFpdi;
use App\Service\ServiceFactory;

// Variables for bulk generation interface only
$pdo = getDbConnection();

// Fetch all active student certificate templates
$stmt = $pdo->prepare("SELECT * FROM certificate_templates WHERE use_case_type = 'student' AND status = 'active'");
$stmt->execute();
$templates = $stmt->fetchAll(PDO::FETCH_ASSOC);

// This page is now dedicated to bulk generation only
// Individual certificate generation has been removed as requested
?>

<!DOCTYPE html>
<html>
<head>
    <title>Student Certificate Generator</title>
    <link rel="stylesheet" href="style.css">
    <style>

        .student-badge { 
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 0.9em;
            font-weight: bold;
            display: inline-block;
            margin-bottom: 15px;
            box-shadow: 0 2px 8px rgba(40, 167, 69, 0.3);
        }
        .info-box {
            background: #f8f9fa;
            border-left: 4px solid #28a745;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .info-box h4 {
            margin: 0 0 10px 0;
            color: #28a745;
        }

        .container {
            max-width: 600px;
            margin: 40px auto;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
            padding: 32px;
            text-align: center;
        }
        select {
            padding: 8px 12px;
            border-radius: 4px;
            border: 1px solid #ccc;
            font-size: 1em;
            margin-left: 8px;
            min-width: 220px;
            transition: border-color 0.2s, box-shadow 0.2s;
        }
        select:focus {
            border-color: #007bff;
            box-shadow: 0 0 4px #007bff33;
            outline: none;
        }
        #publicLink {
            padding: 8px 12px;
            border-radius: 4px;
            border: 1px solid #ccc;
            font-size: 1em;
            margin-top: 8px;
            margin-bottom: 8px;
            width: 60%;
            transition: border-color 0.2s, box-shadow 0.2s;
            box-sizing: border-box;
        }
        #publicLink:focus {
            border-color: #007bff;
            box-shadow: 0 0 4px #007bff33;
            outline: none;
        }
        .btn {
            background: #007bff;
            color: #fff;
            border: none;
            padding: 8px 18px;
            border-radius: 4px;
            cursor: pointer;
            margin-left: 10px;
        }
        .btn:hover { background: #0056b3; }
    </style>

</head>
<body>
<div style="display:flex;flex-direction:column;align-items:center;margin-top:36px;">
<img src="../img/logo.png" alt="Logo" style="width:120px;margin-bottom:18px;">
    <div class="student-badge">🎓 Student Certificates</div>
    <h2 style="text-align:center;">Student Certificate Generator</h2>
    
    <!-- Bulk Certificate Generation -->
        <h3 style="text-align: center; margin-bottom: 20px;">🔗 Bulk Student Certificate Generation</h3>
        <p style="text-align: center;">Generate multiple student certificates at once using Excel/CSV upload</p>
        
        <div style="text-align: center; margin-top: 20px;">
            <label for="bulk_template_id"><strong>Select Student Certificate Template:</strong></label>
            <select id="bulk_template_id">
                <option value="">-- Select Template --</option>
                <?php foreach ($templates as $tpl): ?>
                    <option value="<?= htmlspecialchars($tpl['id']) ?>"><?= htmlspecialchars($tpl['name']) ?></option>
                <?php endforeach; ?>
            </select>
           <br><br> <button type="button" id="createLinkBtn" class="btn">Create Bulk Generation Link</button>
        </div>
        
        <div id="publicLinkContainer" style="display:none; text-align:center; margin-top:20px;">
            <label><strong>Bulk Generation Link:</strong></label>
            <input type="text" id="publicLink" readonly style="width:70%;">
            <br><br><button type="button" id="copyLinkBtn" onclick="copyPublicLink()" class="btn">Copy Link</button>
            <span id="copyMsg" style="margin-left:12px;color:green;display:none;">Link copied!</span>
        </div>
    </div>
</div>
<script>
document.getElementById('createLinkBtn').onclick = function() {
    var templateId = document.getElementById('bulk_template_id').value;
    if (!templateId) {
        alert('Please select a template for bulk generation.');
        return;
    }
    var link = window.location.origin + '/CertifyEd/public/student_bulk_generate.php?template_id=' + templateId;
    document.getElementById('publicLink').value = link;
    document.getElementById('publicLinkContainer').style.display = 'block';
};

function copyPublicLink() {
    var input = document.getElementById('publicLink');
    input.select();
    input.setSelectionRange(0, 99999);
    document.execCommand('copy');

    var msg = document.getElementById('copyMsg');
    msg.style.display = 'inline';
    setTimeout(function() {
        msg.style.display = 'none';
    }, 1500);
}
</script>
</body>
</html>