<?php
session_start();
if (empty($_SESSION['user_logged_in']) && empty($_SESSION['admin_logged_in'])) {
    echo "<script>window.top.location.href = 'login.php';</script>";
    exit;
}
require_once __DIR__ . '/../config/config.php';
$pdo = getDbConnection();
$stmt = $pdo->prepare("SELECT * FROM certificate_templates WHERE use_case_type = 'general_teacher' AND status = 'active'");
$stmt->execute();
$templates = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Direct Teacher Certificate Links</title>
    <link rel="stylesheet" href="style.css">
    <style>
        input.copy-link {
            width: 380px;
            font-size: 0.95em;
        }
        .btn-primary {
            background: #1976d2;
            color: #fff;
            border: none;
            border-radius: 5px;
            padding: 10px 22px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s;
            box-shadow: 0 1px 4px rgba(25, 118, 210, 0.10);
        }
        .btn-primary:hover {
            background: #115293;
        }
    </style>
</head>
<body>
    
    <h2 style="text-align:center;margin-bottom:20px;">Direct Teacher Certificate Links</h2>
    <div class="container" style="max-width:420px;margin:40px auto 0 auto;background:#fff;border-radius:10px;box-shadow:0 2px 12px rgba(0,0,0,0.08);padding:32px 24px 32px 24px;">
        <div class="form-group">
            <label for="templateSelect">Select Certificate Template:</label>
            <select id="templateSelect" style="width:100%;padding:8px;margin-bottom:16px;">
                <option value="">-- Select --</option>
                <?php foreach ($templates as $tpl): ?>
                    <option value="<?= $tpl['id'] ?>"><?= htmlspecialchars($tpl['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div style="margin-bottom:10px;"></div>
        <label for="directLink">Direct Link:</label>
        <input class="copy-link" id="directLink" type="text" value="" readonly style="width:100%;">
        <button class="btn" style="margin-top:10px;" onclick="copyDirectLink();return false;">Copy Link</button>
    </div>
    <script>
    var templateLinks = {};
    <?php foreach ($templates as $tpl): ?>
    templateLinks['<?= $tpl['id'] ?>'] = "<?= (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . '/teacher_certificate.php?template_id=' . $tpl['id'] ?>";
    <?php endforeach; ?>
    document.getElementById('templateSelect').addEventListener('change', function() {
        var tid = this.value;
        document.getElementById('directLink').value = tid && templateLinks[tid] ? templateLinks[tid] : '';
    });
    function copyDirectLink() {
        var copyText = document.getElementById('directLink');
        copyText.select();
        copyText.setSelectionRange(0, 99999);
        document.execCommand('copy');
        alert('Link copied to clipboard!');
    }
    </script>
    
</body>
</html>