<?php
// Temporary download endpoint for generated certificates
$download_id = $_GET['id'] ?? '';

if (!$download_id || !preg_match('/^temp_cert_[a-f0-9.]+$/', $download_id)) {
    http_response_code(404);
    die('Invalid download ID');
}

$temp_file = __DIR__ . '/../storage/temp/' . $download_id . '.pdf';

if (!file_exists($temp_file)) {
    http_response_code(404);
    die('File not found or expired');
}

// Check file age - delete if older than 30 days
if (filemtime($temp_file) < time() - (30 * 24 * 3600)) {
    unlink($temp_file);
    http_response_code(404);
    die('Download link expired');
}

// Output the PDF
header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="certificate.pdf"');
header('Content-Length: ' . filesize($temp_file));

readfile($temp_file);

// Clean up the temporary file after download
unlink($temp_file);
exit;
?>