<?php
session_start();
require_once __DIR__ . '/../config/config.php';

// Only allow admins
if (empty($_SESSION['admin_logged_in'])) {
    echo "<script>window.top.location.href = 'login.php';</script>";
    exit;
}

$pdo = getDbConnection();
$error = '';
$success = '';

// Handle Deactivate User
if (isset($_GET['delete'])) {
    $delete_id = intval($_GET['delete']);
    // Prevent deactivating self
    $stmt = $pdo->prepare("SELECT email FROM users WHERE id = ?");
    $stmt->execute([$delete_id]);
    $del_user = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($del_user && $del_user['email'] !== $_SESSION['admin_email']) {
        $stmt = $pdo->prepare("UPDATE users SET status = 'deactivated' WHERE id = ?");
        $stmt->execute([$delete_id]);
        $success = "User deactivated successfully.";
    } else {
        $error = "You cannot deactivate your own account.";
    }
}

// Handle Edit User
$edit_user = null;
if (isset($_GET['edit'])) {
    $edit_id = intval($_GET['edit']);
    $stmt = $pdo->prepare("SELECT id, name, email, role FROM users WHERE id = ?");
    $stmt->execute([$edit_id]);
    $edit_user = $stmt->fetch(PDO::FETCH_ASSOC);
}

// Handle Update User
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_user'])) {
    $id = intval($_POST['id']);
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $role = $_POST['role'];
    $password = $_POST['password'];
    if ($password) {
        $password_hash = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE users SET name=?, email=?, role=?, password_hash=? WHERE id=?");
        $stmt->execute([$name, $email, $role, $password_hash, $id]);
    } else {
        $stmt = $pdo->prepare("UPDATE users SET name=?, email=?, role=? WHERE id=?");
        $stmt->execute([$name, $email, $role, $id]);
    }
    $success = "User updated successfully.";
    $edit_user = null;
}

// Handle Add User
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_user'])) {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $role = $_POST['role'];
    $password = $_POST['password'];
    $password_hash = password_hash($password, PASSWORD_DEFAULT);

    // Check if email exists
    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->execute([$email]);
    if ($stmt->fetch()) {
        $error = "Email already exists.";
    } else {
        $stmt = $pdo->prepare("INSERT INTO users (name, email, role, password_hash) VALUES (?, ?, ?, ?)");
        if ($stmt->execute([$name, $email, $role, $password_hash])) {
            $success = "User added successfully.";
        } else {
            $error = "You do not have permission to add this user.";
        }
    }
}

// Fetch all users
if ($_SESSION['admin_role'] === 'super_admin') {
    $stmt = $pdo->query("SELECT id, name, email, role FROM users WHERE status = 'active' ORDER BY id DESC");
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
} else {
    $stmt = $pdo->prepare("SELECT id, name, email, role FROM users WHERE status = 'active' AND (role = 'backend_user' OR email = ?) ORDER BY id DESC");
    $stmt->execute([$_SESSION['admin_email']]);
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

?>

<!DOCTYPE html>
<html>
<head>
    <title>User Management - CertifyEd</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <!-- Add this container div around your upload form section -->
    <h2 style="text-align:center;margin-bottom:20px;">User Management</h2>
   
    <?php if ($error): ?><p style="color:red; text-align:center;"><?= htmlspecialchars($error) ?></p><?php endif; ?>
    <?php if ($success): ?><p style="color:green; text-align:center;"><?= htmlspecialchars($success) ?></p><?php endif; ?>

    <div class="user-form-section">
    <?php if ($edit_user): ?>
        <h3>Edit User</h3>
        <form method="post">
            <input type="hidden" name="update_user" value="1">
            <input type="hidden" name="id" value="<?= htmlspecialchars($edit_user['id']) ?>">
            <label>Name: <input type="text" name="name" value="<?= htmlspecialchars($edit_user['name']) ?>" required></label><br>
            <label>Email: <input type="email" name="email" value="<?= htmlspecialchars($edit_user['email']) ?>" required></label><br>
            <label>Role:
                <select name="role">
                    <?php if ($_SESSION['admin_role'] === 'super_admin'): ?>
                        <option value="super_admin" <?= $edit_user['role'] == 'super_admin' ? 'selected' : '' ?>>Super Admin</option>
                        <option value="admin" <?= $edit_user['role'] == 'admin' ? 'selected' : '' ?>>Admin</option>
                    <?php endif; ?>
                    <option value="backend_user" <?= $edit_user['role'] == 'backend_user' ? 'selected' : '' ?>>Backend User</option>
                </select>
            </label><br>
            <label>New Password (leave blank to keep current): <input type="password" name="password"></label><br>
            <button type="submit" class="btn">Update User</button>
            <a href="users.php">Cancel</a>
        </form>
        </div>
        <hr>
    <?php else: ?>
        <h3>Add New User</h3>
        
        <form method="post">
            <input type="hidden" name="add_user" value="1">
            <label>Name: <input type="text" name="name" required></label><br>
            <label>Email: <input type="email" name="email" required></label><br>
            <label>Role:
                <select name="role">
                    <?php if ($_SESSION['admin_role'] === 'super_admin'): ?>
                        <option value="super_admin">Super Admin</option>
                        <option value="admin">Admin</option>
                    <?php endif; ?>
                    <option value="backend_user">Backend User</option>
                </select>
            </label><br>
            <label>Password: <input type="password" name="password" required></label><br>
            <button type="submit" class="btn">Add User</button>
        </form>
    <?php endif; ?>
    
                    </div>
<!-- Add this container div around your upload form section -->
<div class="container" >
    <div class="user-table-section">
        <h3>All Users</h3>
        <table border="1" cellpadding="6">
            <tr>
                <th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Actions</th>
            </tr>
            <?php foreach ($users as $user): ?>
            <tr>
                <td><?= htmlspecialchars($user['id']) ?></td>
                <td><?= htmlspecialchars($user['name']) ?></td>
                <td><?= htmlspecialchars($user['email']) ?></td>
                <td><?= htmlspecialchars($user['role']) ?></td>
                <td style="text-align:center;">
                    <?php
                    // Super admin can edit/delete anyone except themselves
                    if ($_SESSION['admin_role'] === 'super_admin' && $user['email'] !== $_SESSION['admin_email']) {
                        echo '<a href="users.php?edit=' . $user['id'] . '"><img src="../img/edit.png" alt="Edit" title="Edit" style="width:18px;height:18px;vertical-align:middle;margin-right:8px;"></a>';
                        echo '<a href="users.php?delete=' . $user['id'] . '" onclick="return confirm(\'Are you sure?\')"><img src="../img/delete.png" alt="Delete" title="Delete" style="width:18px;height:18px;vertical-align:middle;"></a>';
                    }
                    // Normal admin can only edit/delete backend users
                    elseif ($_SESSION['admin_role'] === 'admin' && $user['role'] === 'backend_user') {
                        echo '<a href="users.php?edit=' . $user['id'] . '"><img src="../img/edit.png" alt="Edit" title="Edit" style="width:18px;height:18px;vertical-align:middle;margin-right:8px;"></a>';
                        echo '<a href="users.php?delete=' . $user['id'] . '" onclick="return confirm(\'Are you sure?\')"><img src="../img/delete.png" alt="Delete" title="Delete" style="width:18px;height:18px;vertical-align:middle;"></a>';
                    }
                    ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
    
</body>
</html>