<?php

namespace App\Service;

use Exception;

/**
 * Interface for centralized error handling
 */
interface ErrorHandlerInterface
{
    /**
     * Handle PDF processing errors
     *
     * @param Exception $exception The exception that occurred
     * @param array $context Additional context information
     * @return ErrorResponse Structured error response
     */
    public function handlePdfError(Exception $exception, array $context): ErrorResponse;

    /**
     * Log PDF processing errors
     *
     * @param string $templateId Identifier for the template
     * @param string $error Error message
     * @param array $context Additional context information
     * @return void
     */
    public function logPdfError(string $templateId, string $error, array $context): void;
}