<?php

namespace App\Service;

/**
 * Response object for error handling operations
 */
class ErrorResponse
{
    public string $userMessage;
    public string $technicalMessage;
    public array $suggestedActions;
    public string $errorCode;

    public function __construct(
        string $userMessage,
        string $technicalMessage,
        array $suggestedActions = [],
        string $errorCode = 'PDF_ERROR'
    ) {
        $this->userMessage = $userMessage;
        $this->technicalMessage = $technicalMessage;
        $this->suggestedActions = $suggestedActions;
        $this->errorCode = $errorCode;
    }

    /**
     * Create error response for PDF compatibility issues
     */
    public static function pdfCompatibilityError(string $templateName, string $technicalDetails): self
    {
        return new self(
            "The PDF template '{$templateName}' uses compression that is not supported. Please try a different template or contact support.",
            $technicalDetails,
            [
                'Try using a different PDF template',
                'Contact your administrator to replace the template',
                'Use the fallback generation option if available'
            ],
            'PDF_COMPATIBILITY_ERROR'
        );
    }

    /**
     * Create error response for general PDF processing errors
     */
    public static function processingError(string $message, string $technicalDetails): self
    {
        return new self(
            "Certificate generation failed: {$message}",
            $technicalDetails,
            [
                'Try generating the certificate again',
                'Contact support if the problem persists'
            ],
            'PDF_PROCESSING_ERROR'
        );
    }
}