<?php

namespace App\Service;

/**
 * Interface for fallback PDF generation - Universal PDF Support
 */
interface FallbackPdfGeneratorInterface
{
    /**
     * Generate certificate from incompatible template
     *
     * @param string $templatePath Path to the incompatible PDF template
     * @param array $fieldData Data to populate in the certificate
     * @return PdfResult Result of the fallback generation
     */
    public function generateFromIncompatibleTemplate(string $templatePath, array $fieldData): PdfResult;

    /**
     * Create blank certificate with field data
     *
     * @param array $fieldData Data to populate in the certificate
     * @param array $templateInfo Information about the original template
     * @return PdfResult Result of the blank certificate generation
     */
    public function createBlankCertificate(array $fieldData, array $templateInfo): PdfResult;

    /**
     * Generate certificate using image conversion method (handles ANY PDF)
     *
     * @param string $templatePath Path to the PDF template
     * @param array $fieldData Data to populate in the certificate
     * @return PdfResult Result of the image conversion generation
     */
    public function generateFromImageConversion(string $templatePath, array $fieldData): PdfResult;

    /**
     * Recreate template structure without importing original PDF
     *
     * @param string $templatePath Path to the PDF template
     * @param array $fieldData Data to populate in the certificate
     * @param array $templateMetadata Metadata about the template
     * @return PdfResult Result of the template recreation
     */
    public function recreateTemplateStructure(string $templatePath, array $fieldData, array $templateMetadata): PdfResult;
}