<?php

namespace App\Service;

/**
 * Interface for PDF processing operations
 */
interface PdfProcessorInterface
{
    /**
     * Process a PDF template with field data
     *
     * @param string $templatePath Path to the PDF template file
     * @param array $fieldData Data to populate in the template
     * @return PdfResult Result of the PDF processing operation
     */
    public function processPdfTemplate(string $templatePath, array $fieldData): PdfResult;

    /**
     * Validate PDF compatibility with FPDI
     *
     * @param string $templatePath Path to the PDF template file
     * @return ValidationResult Result of the compatibility validation
     */
    public function validatePdfCompatibility(string $templatePath): ValidationResult;
}