<?php

namespace App\Service;

/**
 * Result object for PDF processing operations
 */
class PdfResult
{
    public bool $success;
    public ?string $pdfContent;
    public ?string $errorMessage;
    public array $metadata;
    public string $processingMethod; // 'fpdi', 'fallback', 'blank'

    public function __construct(
        bool $success = false,
        ?string $pdfContent = null,
        ?string $errorMessage = null,
        array $metadata = [],
        string $processingMethod = 'fpdi'
    ) {
        $this->success = $success;
        $this->pdfContent = $pdfContent;
        $this->errorMessage = $errorMessage;
        $this->metadata = $metadata;
        $this->processingMethod = $processingMethod;
    }

    /**
     * Create a successful result
     */
    public static function success(string $pdfContent, string $processingMethod = 'fpdi', array $metadata = []): self
    {
        return new self(true, $pdfContent, null, $metadata, $processingMethod);
    }

    /**
     * Create a failed result
     */
    public static function failure(string $errorMessage, array $metadata = []): self
    {
        return new self(false, null, $errorMessage, $metadata);
    }
}