<?php

namespace App\Service;

/**
 * Simple service factory for dependency injection
 */
class ServiceFactory
{
    private static ?ErrorHandler $errorHandler = null;
    private static ?FallbackPdfGenerator $fallbackGenerator = null;
    private static ?PdfProcessor $pdfProcessor = null;
    private static ?TemplateValidator $templateValidator = null;

    /**
     * Get ErrorHandler instance
     */
    public static function getErrorHandler(): ErrorHandler
    {
        if (self::$errorHandler === null) {
            self::$errorHandler = new ErrorHandler();
        }
        return self::$errorHandler;
    }

    /**
     * Get FallbackPdfGenerator instance
     */
    public static function getFallbackGenerator(): FallbackPdfGenerator
    {
        if (self::$fallbackGenerator === null) {
            self::$fallbackGenerator = new FallbackPdfGenerator(self::getErrorHandler());
        }
        return self::$fallbackGenerator;
    }

    /**
     * Get PdfProcessor instance
     */
    public static function getPdfProcessor(): PdfProcessor
    {
        if (self::$pdfProcessor === null) {
            self::$pdfProcessor = new PdfProcessor(
                self::getErrorHandler(),
                self::getFallbackGenerator()
            );
        }
        return self::$pdfProcessor;
    }

    /**
     * Get TemplateValidator instance
     */
    public static function getTemplateValidator(): TemplateValidator
    {
        if (self::$templateValidator === null) {
            self::$templateValidator = new TemplateValidator(self::getErrorHandler());
        }
        return self::$templateValidator;
    }
}