<?php

namespace App\Service;

/**
 * Interface for PDF template validation
 */
interface TemplateValidatorInterface
{
    /**
     * Validate a PDF template
     *
     * @param string $templatePath Path to the PDF template file
     * @return ValidationResult Result of the template validation
     */
    public function validateTemplate(string $templatePath): ValidationResult;

    /**
     * Check PDF compatibility with FPDI
     *
     * @param string $templatePath Path to the PDF template file
     * @return bool True if compatible, false otherwise
     */
    public function checkPdfCompatibility(string $templatePath): bool;
}