<?php

namespace App\Service;

/**
 * Result object for template validation operations
 */
class ValidationResult
{
    public bool $isValid;
    public bool $fpdiCompatible;
    public array $issues;
    public array $recommendations;

    public function __construct(
        bool $isValid = false,
        bool $fpdiCompatible = false,
        array $issues = [],
        array $recommendations = []
    ) {
        $this->isValid = $isValid;
        $this->fpdiCompatible = $fpdiCompatible;
        $this->issues = $issues;
        $this->recommendations = $recommendations;
    }

    /**
     * Create a valid result
     */
    public static function valid(bool $fpdiCompatible = true): self
    {
        return new self(true, $fpdiCompatible);
    }

    /**
     * Create an invalid result
     */
    public static function invalid(array $issues, array $recommendations = []): self
    {
        return new self(false, false, $issues, $recommendations);
    }

    /**
     * Add an issue to the validation result
     */
    public function addIssue(string $issue): self
    {
        $this->issues[] = $issue;
        return $this;
    }

    /**
     * Add a recommendation to the validation result
     */
    public function addRecommendation(string $recommendation): self
    {
        $this->recommendations[] = $recommendation;
        return $this;
    }
}